unit ModbusAsyncProTest;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, AdPacket, OoMisc, AdStatLt, AdPort, StdCtrls, ComCtrls,
  Spin;

type
  TForm1 = class(TForm)
    AVRcoModbusComPort: TApdComPort;
    Voltage1Panel: TPanel;
    Voltage1: TProgressBar;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Memo1: TMemo;
    ReadModbusTagsTimer: TTimer;
    ModbusDataReceived: TApdDataPacket;
    Label4: TLabel;
    ComPortSpinEdit: TSpinEdit;
    RunButton: TButton;
    procedure ReadModbusTagsTimerTimer(Sender: TObject);
    procedure ModbusDataReceivedStringPacket(Sender: TObject;
      Data: String);
    procedure RunButtonClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ComPortSpinEditChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.ReadModbusTagsTimerTimer(Sender: TObject);
begin
   AVRcoModbusComPort.Output := ':010400080002F1' + CHR(13) + CHR(10);
end;

procedure TForm1.ModbusDataReceivedStringPacket(Sender: TObject;
  Data: String);
var
   f: single;
   l: longword;
   p: pointer;
   ps: psingle;
   s: string;
begin
   // since this is a quick example, we will not calculate LRC
   // if you want that, you can find example how to do it in AVRco source
   s := '$' + Copy(Data, 5, 4) + Copy(Data, 1, 4);
   l := StrToInt(s);
   //caption := IntToStr(l);

   // let's convert longword to float
   p  := @l;
   ps := PSingle(P);
   f  := ps^;
   Voltage1.Position := Round(f*100);
   Voltage1Panel.Caption := FloatToStrF(f, ffFixed, 4, 2) + ' V';
end;

procedure TForm1.RunButtonClick(Sender: TObject);
begin
   ReadModbusTagsTimer.Enabled := false;
   AVRcoModbusComPort.Open := false;
   AVRcoModbusComPort.ComNumber := ComPortSpinEdit.Value;
   AVRcoModbusComPort.Open := true;
   ReadModbusTagsTimer.Enabled := true;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   ReadModbusTagsTimer.Enabled := false;
end;

procedure TForm1.ComPortSpinEditChange(Sender: TObject);
begin
   ReadModbusTagsTimer.Enabled := false;
end;

end.
